Ext.data.JsonP.sol_common_ix_DynKwlSearchIterator({"tagname":"class","name":"sol.common.ix.DynKwlSearchIterator","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.DynKwlSearchIterator.js","href":"lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator"}],"author":[{"tagname":"author","name":"NM, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"requires":["sol.common.Locale","sol.common.SordUtils","sol.common.StringUtils","sol.common.UserProfile","sol.common.ix.DynKwlUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":["sol.common.ix.DynKwlMixin"],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"searchCount","tagname":"cfg","owner":"sol.common.ix.DynKwlSearchIterator","id":"cfg-searchCount","meta":{}},{"name":"searchParams","tagname":"cfg","owner":"sol.common.ix.DynKwlSearchIterator","id":"cfg-searchParams","meta":{}},{"name":"sordZ","tagname":"cfg","owner":"sol.common.ix.DynKwlSearchIterator","id":"cfg-sordZ","meta":{}},{"name":"tableHeaders","tagname":"cfg","owner":"sol.common.ix.DynKwlSearchIterator","id":"cfg-tableHeaders","meta":{"required":true}},{"name":"tableKeyNames","tagname":"cfg","owner":"sol.common.ix.DynKwlSearchIterator","id":"cfg-tableKeyNames","meta":{"required":true}},{"name":"tableTitle","tagname":"cfg","owner":"sol.common.ix.DynKwlSearchIterator","id":"cfg-tableTitle","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"_findInfo","tagname":"property","owner":"sol.common.ix.DynKwlSearchIterator","id":"property-_findInfo","meta":{"private":true}},{"name":"errorMessage","tagname":"property","owner":"sol.common.ix.DynKwlSearchIterator","id":"property-errorMessage","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.ix.DynKwlMixin","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"close","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-close","meta":{}},{"name":"createSearchFilterList","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-createSearchFilterList","meta":{}},{"name":"formatNumber","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatNumber","meta":{"private":true}},{"name":"formatRow","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatRow","meta":{"protected":true}},{"name":"getFindInfo","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getFindInfo","meta":{"abstract":true}},{"name":"getHeader","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getHeader","meta":{}},{"name":"getIndexFromName","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getIndexFromName","meta":{"private":true}},{"name":"getKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getKeyNames","meta":{}},{"name":"getMessage","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getMessage","meta":{}},{"name":"getNextRow","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getNextRow","meta":{}},{"name":"getRowData","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getRowData","meta":{"abstract":true}},{"name":"getSearchResults","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getSearchResults","meta":{"private":true}},{"name":"getTableKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-getTableKeyNames","meta":{"protected":true}},{"name":"getTitle","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-getTitle","meta":{}},{"name":"hasMoreRows","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-hasMoreRows","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-initialize","meta":{"private":true}},{"name":"open","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-open","meta":{}},{"name":"openMap","tagname":"method","owner":"sol.common.ix.DynKwlSearchIterator","id":"method-openMap","meta":{}}],"code_type":"ext_define","id":"class-sol.common.ix.DynKwlSearchIterator","short_doc":"Search Iterator used by dynamic keyword lists. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":["sol.common.ix.DynKwlFindChildrenIterator","sol.contact.ix.dynkwl.FindCompanyIterator","sol.contact.ix.dynkwl.FindContactIterator","sol.contact.ix.dynkwl.FindContactlistIterator","sol.dev.ix.dynkwl.FindUnitTestIterator"],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.DynKwlSearchIterator</strong></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='docClass'>sol.common.ix.DynKwlMixin</a></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Locale' rel='sol.common.Locale' class='docClass'>sol.common.Locale</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.UserProfile' rel='sol.common.UserProfile' class='docClass'>sol.common.UserProfile</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlUtils' rel='sol.common.ix.DynKwlUtils' class='docClass'>sol.common.ix.DynKwlUtils</a></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlFindChildrenIterator' rel='sol.common.ix.DynKwlFindChildrenIterator' class='docClass'>sol.common.ix.DynKwlFindChildrenIterator</a></div><div class='dependency'><a href='#!/api/sol.contact.ix.dynkwl.FindCompanyIterator' rel='sol.contact.ix.dynkwl.FindCompanyIterator' class='docClass'>sol.contact.ix.dynkwl.FindCompanyIterator</a></div><div class='dependency'><a href='#!/api/sol.contact.ix.dynkwl.FindContactIterator' rel='sol.contact.ix.dynkwl.FindContactIterator' class='docClass'>sol.contact.ix.dynkwl.FindContactIterator</a></div><div class='dependency'><a href='#!/api/sol.contact.ix.dynkwl.FindContactlistIterator' rel='sol.contact.ix.dynkwl.FindContactlistIterator' class='docClass'>sol.contact.ix.dynkwl.FindContactlistIterator</a></div><div class='dependency'><a href='#!/api/sol.dev.ix.dynkwl.FindUnitTestIterator' rel='sol.dev.ix.dynkwl.FindUnitTestIterator' class='docClass'>sol.dev.ix.dynkwl.FindUnitTestIterator</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator' target='_blank'>lib_sol.common.ix.DynKwlSearchIterator.js</a></div></pre><div class='doc-contents'><p>Search Iterator used by dynamic keyword lists. This class provides an abstract layer that simplifies the usage\nof keywording information.</p>\n\n<p>If child elements should be returned please refer to the subclass <a href=\"#!/api/sol.common.ix.DynKwlFindChildrenIterator\" rel=\"sol.common.ix.DynKwlFindChildrenIterator\" class=\"docClass\">sol.common.ix.DynKwlFindChildrenIterator</a>\nwhich implements that scenario. In most cases it is recommended to implement a specific scenario by a generalized\nsubclass.</p>\n\n<p>A DynKwlSearchIterator required an Index Server FindInfo object in order to find the required sord elements.\nThanks to a function <code>getRowData</code> the result of one row can be defined by keywording information.</p>\n\n<h1>Example implementation</h1>\n\n<p>Following example shows the implementation of an iterator that returns child elements of a given parent.</p>\n\n<pre><code>// script: sol.common.ix.DynKwlFindChildrenIterator.js\n\n<a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>('<a href=\"#!/api/sol.common.ix.DynKwlFindChildrenIterator\" rel=\"sol.common.ix.DynKwlFindChildrenIterator\" class=\"docClass\">sol.common.ix.DynKwlFindChildrenIterator</a>', {\n  extend: '<a href=\"#!/api/sol.common.ix.DynKwlSearchIterator\" rel=\"sol.common.ix.DynKwlSearchIterator\" class=\"docClass\">sol.common.ix.DynKwlSearchIterator</a>',\n  tableHeaders: [\"Name\", \"Description\"],\n  parentId: null,\n  searchParams: [{mode: 'STARTS_WITH'}],\n\n  initialize: function (config) {\n    config = config || {};\n    this.parentId = config.parentId || this.parentId;\n\n    this.$super('<a href=\"#!/api/sol.common.ix.DynKwlSearchIterator\" rel=\"sol.common.ix.DynKwlSearchIterator\" class=\"docClass\">sol.common.ix.DynKwlSearchIterator</a>', 'initialize', arguments);\n  },\n\n  // implement getFindInfo.\n  getFindInfo: function(filterList) {\n       var findInfo,\n         findChildren, findByIndex;\n\n       findInfo = new FindInfo();\n       findChildren = new FindChildren();\n       findChildren.parentId = this.parentId;\n    findInfo.findChildren = findChildren;\n\n    if (filterList &amp;&amp; filterList.length &gt; 0) {\n      findByIndex = new FindByIndex();\n      findByIndex.name = filterList[0];\n      findInfo.findByIndex = findByIndex;\n    }\n\n    return findInfo;\n  },\n\n  getRowData: function(sord) {\n       return [sord.name, sord.desc];\n  }\n});\n</code></pre>\n\n<p>Implementation of an Index Server data iterator that can be used by keywording forms:</p>\n\n<pre><code>// script: sol.pubsec.ix.dynkwl.generators.NameFile.js\n\n<a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>('sol.pubsec.ix.dynkwl.generators.NameFile', {\n  extend: '<a href=\"#!/api/sol.common.ix.DynKwlFindChildrenIterator\" rel=\"sol.common.ix.DynKwlFindChildrenIterator\" class=\"docClass\">sol.common.ix.DynKwlFindChildrenIterator</a>',\n\n  tableTitle: 'Generators - File Name',\n  tableKeyNames: [\"FILE_NAME_GEN\", null],\n  parentId: '123'\n\n});\n\nfunction getDataIterator() {\n  var iterator;\n  iterator = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>('sol.pubsec.ix.dynkwl.generators.NameFile', {  });\n  return new DynamicKeywordDataProvider(iterator);\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-tableHeaders' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-cfg-tableHeaders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-cfg-tableHeaders' class='name expandable'>tableHeaders</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>column header names. ...</div><div class='long'><p>column header names. if null column is hidden in the client.</p>\n\n<pre><code>[\"Name\", \"Description\"]\n</code></pre>\n</div></div></div><div id='cfg-tableKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-cfg-tableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-cfg-tableKeyNames' class='name expandable'>tableKeyNames</a> : Array<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>mapping between columns and elo group or map fields. ...</div><div class='long'><p>mapping between columns and elo group or map fields. if null, value is not transferred.</p>\n\n<pre><code>// GRP field     map static field           map table field\n['RECORD_REFERENCE', null];\n</code></pre>\n\n<p>Map fields must contain IX_MAP as a prefix and can optionally use {i} as a counter value.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-searchCount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-cfg-searchCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-cfg-searchCount' class='name expandable'>searchCount</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Number of search results to retrieve. ...</div><div class='long'><p>Number of search results to retrieve.\nPlease mind that results should be filtered by the user input.\nDisplaying more than 100 results is not recommended.</p>\n<p>Defaults to: <code>100</code></p></div></div></div><div id='cfg-searchParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-cfg-searchParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-cfg-searchParams' class='name expandable'>searchParams</a> : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Filter values that can be used for creating a FindInfo search definition. ...</div><div class='long'><p>Filter values that can be used for creating a FindInfo search definition.</p>\n\n<pre><code>[{ name: 'FILING_PLAN_REFERENCE', mode: 'STARTS', message: 'field x missing' }]\n</code></pre>\n\n<p>if no name is provided current focused field is used.\nThese values are passed to the <code>getFindInfo</code> function.</p>\n</div></div></div><div id='cfg-sordZ' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-cfg-sordZ' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-cfg-sordZ' class='name expandable'>sordZ</a> : de.elo.ix.client.SordZ<span class=\"signature\"></span></div><div class='description'><div class='short'>Defines which information to retrieve from the search. ...</div><div class='long'><p>Defines which information to retrieve from the search. e.g. <code>SordC.mbAll</code>. Default is <code>SordC.mbAllIndex</code>.</p>\n</div></div></div><div id='cfg-tableTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-cfg-tableTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-cfg-tableTitle' class='name expandable'>tableTitle</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'>name of this table. ...</div><div class='long'><p>name of this table. The title is displayed by the client.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-_findInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-property-_findInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-property-_findInfo' class='name expandable'>_findInfo</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'><p>created findInfo object.</p>\n</div><div class='long'><p>created findInfo object.</p>\n</div></div></div><div id='property-errorMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-property-errorMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-property-errorMessage' class='name expandable'>errorMessage</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Error message that is passed to the client if value is missing. ...</div><div class='long'><p>Error message that is passed to the client if value is missing.</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-close' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-close' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-close' class='name expandable'>close</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Closes the connection for both map and non map capable clients. ...</div><div class='long'><p>Closes the connection for both map and non map capable clients.</p>\n</div></div></div><div id='method-createSearchFilterList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-createSearchFilterList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-createSearchFilterList' class='name expandable'>createSearchFilterList</a>( <span class='pre'>ec, focusField, fieldIndex, map, sord</span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Internal function that utilizes the creation of filters used by the creation of findInfo objects. ...</div><div class='long'><p>Internal function that utilizes the creation of filters used by the creation of findInfo objects.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.scripting.ScriptExecContext<div class='sub-desc'><p>IX ScriptExecContext</p>\n</div></li><li><span class='pre'>focusField</span> : String<div class='sub-desc'><p>Currently focused field</p>\n</div></li><li><span class='pre'>fieldIndex</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>Map of all entries passed by the client</p>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Values for prepared statement</p>\n</div></li></ul></div></div></div><div id='method-formatNumber' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatNumber' class='name expandable'>formatNumber</a>( <span class='pre'>value, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Formats decimal numbers using sol.common.Locale.formatDecimal. ...</div><div class='long'><p>Formats decimal numbers using <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatRow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatRow' class='name expandable'>formatRow</a>( <span class='pre'>row</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Uses this.formatting to apply formatting to a table row. ...</div><div class='long'><p>Uses <code>this.formatting</code> to apply formatting to a table row.</p>\n\n<h1>Format decimal</h1>\n\n<p>See also <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n\n<pre><code>formatting = [\n  { columnNames: [\"MY_OUTPUT_COLUMN1\"], minimumFractionDigits: 0, maximumFractionDigits: 2 },\n  { columnNames: [\"MY_OUTPUT_COLUMN2\", \"ANOTHER_OUTPUT_COLUMN\"], maximumFractionDigits: 4 }\n];\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : String[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFindInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getFindInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getFindInfo' class='name expandable'>getFindInfo</a>( <span class='pre'>filter</span> ) : de.elo.ix.client.FindInfo<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>This function must be implemented by the child class. ...</div><div class='long'><p>This function must be implemented by the child class. It should return an Index Server FindInfo object that is used by the search.</p>\n\n<pre><code>getFindInfo: function(filterList) {\n  this.log.enter(\"getFindInfo\");\n  var findInfo,\n  findChildren, findByIndex;\n\n  findInfo = new FindInfo();\n  findChildren = new FindChildren();\n  findChildren.parentId = this.parentId;\n  findInfo.findChildren = findChildren;\n\n  if (filterList &amp;&amp; filterList.length &gt; 0) {\n    findByIndex = new FindByIndex();\n    findByIndex.name = filterList[0];\n    findInfo.findByIndex = findByIndex;\n  }\n\n  this.log.exit(\"getFindInfo\");\n  return findInfo;\n},\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filter</span> : String[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.FindInfo</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHeader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getHeader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getHeader' class='name expandable'>getHeader</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the header of this table that can be displayed by the clients. ...</div><div class='long'><p>Returns the header of this table that can be displayed by the clients.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table header</p>\n</div></li></ul></div></div></div><div id='method-getIndexFromName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getIndexFromName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getIndexFromName' class='name expandable'>getIndexFromName</a>( <span class='pre'>name</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getKeyNames' class='name expandable'>getKeyNames</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the keys of this table that can be used in order to map\nmap or group fields with columns. ...</div><div class='long'><p>Returns the keys of this table that can be used in order to map\nmap or group fields with columns.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table keys</p>\n</div></li></ul></div></div></div><div id='method-getMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getMessage' class='name expandable'>getMessage</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the error message that should be displayed by the client\ninstead of the table data. ...</div><div class='long'><p>Returns the error message that should be displayed by the client\ninstead of the table data.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>error message</p>\n</div></li></ul></div></div></div><div id='method-getNextRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getNextRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getNextRow' class='name expandable'>getNextRow</a>( <span class='pre'></span> ) : String[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the next row of the table. ...</div><div class='long'><p>Returns the next row of the table.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table row</p>\n</div></li></ul></div></div></div><div id='method-getRowData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getRowData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getRowData' class='name expandable'>getRowData</a>( <span class='pre'>sord</span> ) : String[]<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>This function must be implemented by the child class. ...</div><div class='long'><p>This function must be implemented by the child class. It should return the data as string[] for one table row.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>Table row</p>\n</div></li></ul></div></div></div><div id='method-getSearchResults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getSearchResults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getSearchResults' class='name expandable'>getSearchResults</a>( <span class='pre'></span> ) : de.elo.ix.client.Sord[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a list of search results based on the given FindInfo object. ...</div><div class='long'><p>Retrieves a list of search results based on the given FindInfo object. Result list is limited to 100 items.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTableKeyNames' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.DynKwlMixin' rel='sol.common.ix.DynKwlMixin' class='defined-in docClass'>sol.common.ix.DynKwlMixin</a><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-getTableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-getTableKeyNames' class='name expandable'>getTableKeyNames</a>( <span class='pre'>focusFieldName</span> ) : String[]<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines the table keys for the output of the dynamic kwl. ...</div><div class='long'><p>Determines the table keys for the output of the dynamic kwl.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>focusFieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTitle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-getTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-getTitle' class='name expandable'>getTitle</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a title for this table used by the user interface. ...</div><div class='long'><p>Returns a title for this table used by the user interface.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Title</p>\n</div></li></ul></div></div></div><div id='method-hasMoreRows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-hasMoreRows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-hasMoreRows' class='name expandable'>hasMoreRows</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if table has more rows. ...</div><div class='long'><p>Returns true if table has more rows.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Has more rows</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.DynKwlMixin-method-initialize\" rel=\"sol.common.ix.DynKwlMixin-method-initialize\" class=\"docClass\">sol.common.ix.DynKwlMixin.initialize</a></p></div></div></div><div id='method-open' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-open' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-open' class='name expandable'>open</a>( <span class='pre'>ec, sord, fieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a connection for the elo java client and non map field capable clients. ...</div><div class='long'><p>Opens a connection for the elo java client and non map field capable clients.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.scripting.ScriptExecContext<div class='sub-desc'>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>working version of the current sord object</p>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>name of the currently focused field</p>\n</div></li></ul></div></div></div><div id='method-openMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlSearchIterator'>sol.common.ix.DynKwlSearchIterator</span><br/><a href='source/lib_sol.common.ix.DynKwlSearchIterator.html#sol-common-ix-DynKwlSearchIterator-method-openMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlSearchIterator-method-openMap' class='name expandable'>openMap</a>( <span class='pre'>ec, map, focusName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens a connection for elo wf forms and map field capable components ...</div><div class='long'><p>Opens a connection for elo wf forms and map field capable components</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ec</span> : de.elo.ix.scripting.ScriptExecContext<div class='sub-desc'>\n</div></li><li><span class='pre'>map</span> : Object<div class='sub-desc'><p>Map of all entries passed by the client</p>\n</div></li><li><span class='pre'>focusName</span> : String<div class='sub-desc'><p>Name of the currently focused field</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});